CREATE TABLE EO_PK (_rowid longlong PRIMARY KEY, tableName char, nextPKey longlong);
CREATE TABLE UserDefaults (_rowid longlong PRIMARY KEY, key char, value char);
INSERT INTO EO_PK VALUES ( 1, 'BEXIgnore' , 100 );
INSERT INTO EO_PK VALUES ( 2, 'Category' , 100 );
INSERT INTO EO_PK VALUES ( 3, 'Client' , 100 );
INSERT INTO EO_PK VALUES ( 4, 'ConsolidatedTax' , 100 );
INSERT INTO EO_PK VALUES ( 5, 'Estimate' , 100 );
INSERT INTO EO_PK VALUES ( 6, 'EstimateSlip' , 100 );
INSERT INTO EO_PK VALUES ( 7, 'ExtraFieldNames' , 100 );
INSERT INTO EO_PK VALUES ( 8, 'Invoice' , 100 );
INSERT INTO EO_PK VALUES ( 9, 'Note' , 100 );
INSERT INTO EO_PK VALUES ( 10, 'Payment' , 100 );
INSERT INTO EO_PK VALUES ( 11, 'PaymentInvoiceEntry' , 100 );
INSERT INTO EO_PK VALUES ( 12, 'PaymentMethodType' , 100 );
INSERT INTO EO_PK VALUES ( 13, 'Project' , 100 );
INSERT INTO EO_PK VALUES ( 14, 'ProjectStage' , 100 );
INSERT INTO EO_PK VALUES ( 15, 'ProjectState' , 100 );
INSERT INTO EO_PK VALUES ( 16, 'Retainer' , 100 );
INSERT INTO EO_PK VALUES ( 17, 'SlipTemplate' , 100 );
INSERT INTO EO_PK VALUES ( 18, 'Tax' , 100 );
INSERT INTO EO_PK VALUES ( 19, 'TaxConsolidatedTaxEntry' , 100 );
INSERT INTO EO_PK VALUES ( 20, 'TimeEntry' , 100 );
INSERT INTO EO_PK VALUES ( 21, 'TimeSlip' , 100 );
INSERT INTO EO_PK VALUES ( 22, 'TimeSlipType' , 100 );
INSERT INTO EO_PK VALUES ( 23, 'URLReference' , 100 );
INSERT INTO EO_PK VALUES ( 24, 'User' , 100 );
INSERT INTO EO_PK VALUES ( 25, 'MCUserDefaultsStorage' , 100 );
INSERT INTO EO_PK VALUES ( 26, 'Statement' , 100 );
INSERT INTO EO_PK VALUES ( 27, 'ClientCategory' , 100 );
INSERT INTO EO_PK VALUES ( 28, 'RecurringInvoice' , 100 );
INSERT INTO EO_PK VALUES ( 29, 'ProFormaInvoice' , 100 );
INSERT INTO EO_PK VALUES ( 30, 'ClientABLink' , 100 );
INSERT INTO EO_PK VALUES ( 31, 'ClientPhoto' , 100 );
INSERT INTO EO_PK VALUES ( 32, 'SlipConflict' , 100 );
INSERT INTO EO_PK VALUES ( 33, 'DatabaseConfiguration' , 100 );
INSERT INTO EO_PK VALUES ( 34, 'InvoiceHtml' , 100 );
INSERT INTO EO_PK VALUES ( 35, 'Currency' , 100 );
INSERT INTO EO_PK VALUES ( 36, 'EstimateHtml' , 100 );
INSERT INTO EO_PK VALUES ( 37, 'Extra' , 100 );
INSERT INTO EO_PK VALUES ( 38, 'DatabaseReplicant' , 100 );
INSERT INTO EO_PK VALUES ( 39, 'OfflineConfiguration' , 100 );
INSERT INTO EO_PK VALUES ( 40, 'ReportTemplate' , 100 );
INSERT INTO EO_PK VALUES ( 41, 'ProjectUser' , 100 );
INSERT INTO EO_PK VALUES ( 42, 'FileStorage' , 100 );
INSERT INTO EO_PK VALUES ( 43, 'ReportTemplatePreference' , 100 );
INSERT INTO EO_PK VALUES ( 44, 'Identity' , 100 );
INSERT INTO EO_PK VALUES ( 45, 'ConnectorMap' , 100 );
CREATE TABLE BEXIgnore (_rowid longlong PRIMARY KEY NOT NULL, foreignAppEntityName char, foreignAppImportID char, foreignAppName char);
CREATE TABLE Category (_rowid longlong PRIMARY KEY NOT NULL, name char);
CREATE TABLE Client (mileageDistance double, _rowid longlong PRIMARY KEY NOT NULL, clientNumber char, company char, createDate datetime, email char, extra1 char, extra2 char, extra3 char, extra4 char, firstName char, hourlyRate double, isCompany int, lastName char, mileageRate double, modifyDate datetime, clientCategoryID int, balanceCached double, retainersBalanceCached double, unbilledAmountCached double, incompleteAmountCached double, addressCity char, addressStreet char, addressState char, addressZIP char, addressCountry char, addressFormatted char, clientPhotoID longlong, currentCurrencyID longlong, overdueAmountCached double, overdueAmountValidUntilDate datetime, consolidatedTaxID longlong, invoiceTemplatePrefID longlong, estimateTemplatePrefID longlong, statementTemplatePrefID longlong, taxNumber char, billingIdentityID longlong, prefix char, suffix char, middleName char, nickName char, jobTitle char, department char, formalGreeting char);
CREATE INDEX Client_clientCategoryID_index ON Client (clientCategoryID);
CREATE TABLE ConsolidatedTax (active int, atomic int, _rowid longlong PRIMARY KEY NOT NULL, createDate datetime, name char, parentConsolidatedTaxID int);
CREATE INDEX ConsolidatedTax_parentConsolidatedTaxID_index ON ConsolidatedTax (parentConsolidatedTaxID);
CREATE TABLE Estimate (billingsFileID int, comment char, compoundSecondaryTax int, consolidatedTaxID int, createDate datetime, discount double, dueDate datetime, _rowid longlong PRIMARY KEY NOT NULL, estimateNumber char, markup double, modifyDate datetime, name char, projectID int, sentDate datetime, state int, subTotal double, tax1 double, tax1Name char, tax2 double, tax2Name char, useTax1 int, useTax2 int, userFileID int, estimateHtmlID longlong);
CREATE INDEX Estimate_projectID_index ON Estimate (projectID);
CREATE TABLE EstimateSlip (categoryID int, userID int, comment char, compoundSecondaryTax int, consolidatedTaxID int, createDate datetime, discount double, distance double, dueDate datetime, duration double, endDateTime datetime, estimateID int, foreignAppEntityName char, foreignAppImportID char, foreignAppLastTouchDate datetime, foreignAppName char, foreignAppUser char, markup double, mileageType int, modifyDate datetime, name char, nature int, projectID int, rate double, roundTime int, startDateTime datetime, tax1 double, tax1Name char, tax2 double, tax2Name char, _rowid longlong PRIMARY KEY NOT NULL, timeSlipRefID int, total double, typeID int, units double, useTax1 int, useTax2 int, uuid char);
CREATE INDEX EstimateSlip_estimateID_index ON EstimateSlip (estimateID);
CREATE INDEX EstimateSlip_projectID_index ON EstimateSlip (projectID);
CREATE TABLE ExtraFieldNames (extraField1Name char, extraField2Name char, extraField3Name char, extraField4Name char, extraField5Name char, extraField6Name char, extraField7Name char, extraField8Name char, _rowid longlong PRIMARY KEY NOT NULL, forEntity integer);
CREATE TABLE Invoice (billingsFileID int, comment char, compoundSecondaryTax int, consolidatedTaxID int, createDate datetime, discount double, dueDate datetime, invoiceDate datetime, _rowid longlong PRIMARY KEY NOT NULL, invoiceNumber char, markup double, modifyDate datetime, name char, sentDate datetime, state int, tax1 double, tax1Name char, tax2 double, tax2Name char, taxPointDate datetime, useTax1 int, useTax2 int, userFileID int, clientID int, projectID int, invoiceHtmlID longlong, totalCached double);
CREATE INDEX Invoice_clientID_index ON Invoice (clientID);
CREATE TABLE Note (contents object, createDate datetime, modifyDate datetime, name char, _rowid longlong PRIMARY KEY NOT NULL, plainContents char, projectID int);
CREATE INDEX Note_projectID_index ON Note (projectID);
CREATE TABLE Payment (cachedAppliedAmount double, comment char, createDate datetime, methodID int, modifyDate datetime, name char, _rowid longlong PRIMARY KEY NOT NULL, projectID int, total double, clientID int, baseCurrencyTotal double, baseCurrencyManuallyEntered int);
CREATE INDEX Payment_clientID_index ON Payment (clientID);
CREATE TABLE PaymentInvoiceEntry (amountApplied double, createDate datetime, _rowid longlong PRIMARY KEY NOT NULL, invoiceID int, modifyDate datetime, paymentID int);
CREATE INDEX PaymentInvoiceEntry_invoiceID_index ON PaymentInvoiceEntry (invoiceID);
CREATE INDEX PaymentInvoiceEntry_paymentID_index ON PaymentInvoiceEntry (paymentID);
CREATE TABLE PaymentMethodType (name char, _rowid longlong PRIMARY KEY NOT NULL, useRetainer int);
CREATE TABLE Project (balance double, clientID int, completeDate datetime, createDate datetime, discount double, dueDate datetime, extraField1 char, extraField2 char, extraField3 char, extraField4 char, extraField5 char, extraField6 char, extraField7 char, extraField8 char, foreignAppEntityName char, foreignAppImportID char, foreignAppLastTouchDate datetime, foreignAppName char, foreignAppUser char, modifyDate datetime, name char, nickname char, objective char, poNumber char, projectCode char, _rowid longlong PRIMARY KEY NOT NULL, stageID int, startDate datetime, stateID int, total double, useNickname int, uuid char, totalCached double, unbilledCached double, incompleteCached double, estimatePendingCached double, durationOfSlipsCached long, approverID longlong);
CREATE INDEX Project_clientID_index ON Project (clientID);
CREATE TABLE ProjectStage (name char, _rowid longlong PRIMARY KEY NOT NULL);
CREATE TABLE ProjectState (name char, stateCode int, _rowid longlong PRIMARY KEY NOT NULL);
CREATE TABLE Retainer (amountApplied double, createDate datetime, modifyDate datetime, name char, projectID int, _rowid longlong PRIMARY KEY NOT NULL, total double, clientID int, comment char, methodID int, baseCurrencyTotal double, baseCurrencyManuallyEntered int);
CREATE INDEX Retainer_clientID_index ON Retainer (clientID);
CREATE TABLE SlipTemplate (categoryID int, userID int, comment char, consolidatedTaxID int, discount double, markup double, name char, nature int, rate double, slipName char, _rowid longlong PRIMARY KEY NOT NULL, typeID int, units double, useTax1 int, useTax2 int, recurringInvoiceID int);
CREATE TABLE Tax (active int, compound int, consolidatedTaxID int, createDate datetime, name char, orderIndex int, parentTaxID int, rate double, registrationNum char, _rowid longlong PRIMARY KEY NOT NULL);
CREATE INDEX Tax_consolidatedTaxID_index ON Tax (consolidatedTaxID);
CREATE INDEX Tax_parentTaxID_index ON Tax (parentTaxID);
CREATE TABLE TaxConsolidatedTaxEntry (consolidatedTaxID int, orderIndex int, _rowid longlong PRIMARY KEY NOT NULL, taxID int);
CREATE INDEX TaxConsolidatedTaxEntry_consolidatedTaxID_index ON TaxConsolidatedTaxEntry (consolidatedTaxID);
CREATE INDEX TaxConsolidatedTaxEntry_taxID_index ON TaxConsolidatedTaxEntry (taxID);
CREATE TABLE TimeEntry (comment char, createDate datetime, endDateTime datetime, foreignAppEntityName char, foreignAppImportID char, foreignAppLastTouchDate datetime, foreignAppName char, foreignAppUser char, isManual int, modifyDate datetime, startDateTime datetime, _rowid longlong PRIMARY KEY NOT NULL, timeSlipID int, uuid char);
CREATE INDEX TimeEntry_endDateTime_index ON TimeEntry (endDateTime);
CREATE INDEX TimeEntry_startDateTime_index ON TimeEntry (startDateTime);
CREATE INDEX TimeEntry_timeSlipID_index ON TimeEntry (timeSlipID);
CREATE TABLE TimeSlip (activeForTiming int, categoryID int, userID int, comment char, compoundSecondaryTax int, consolidatedTaxID int, createDate datetime, discount double, distance double, dueDate datetime, duration double, endDateTime datetime, foreignAppEntityName char, foreignAppImportID char, foreignAppLastTouchDate datetime, foreignAppName char, foreignAppUser char, iCalUID char, invoiceID int, invoicedDate datetime, markup double, mileageType int, modifyDate datetime, name char, nature int, projectID int, rate double, roundTime int, startDateTime datetime, tax1 double, tax1Name char, tax2 double, tax2Name char, _rowid longlong PRIMARY KEY NOT NULL, timeSlipRefID int, total double, typeID int, units double, useTax1 int, useTax2 int, uuid char, invoicedProjectID int, totalCached double, durationCached long, geoLocationStart char, geoLocationEnd char, workflowState int DEFAULT '0', approvedByUserID longlong, approvedDate datetime, extra1 char, extra2 char, extra3 char, extra4 char);
CREATE INDEX TimeSlip_invoiceID_index ON TimeSlip (invoiceID);
CREATE INDEX TimeSlip_projectID_index ON TimeSlip (projectID);
CREATE INDEX TimeSlip_invoicedProjectID_index ON TimeSlip (invoicedProjectID);
CREATE TABLE TimeSlipType (typeCode int, _rowid longlong PRIMARY KEY NOT NULL);
CREATE TABLE URLReference (createDate datetime, kind int, modifyDate datetime, name char, projectID int, url object, _rowid longlong PRIMARY KEY NOT NULL, urlType int, fileStorageID longlong);
CREATE INDEX URLReference_projectID_index ON URLReference (projectID);
CREATE TABLE User (createDate datetime, name char, modifyDate datetime, _rowid longlong PRIMARY KEY NOT NULL, active int NOT NULL DEFAULT '0', password char, canUseBillingsPro int, canUseBillingsProTouch int, canUsePunchcard int, capability4 int, capability5 int, capability6 int, capability7 int, capability8 int);
CREATE TABLE MCUserDefaultsStorage (BlobValue object, HostID char, Key char, LastType int, _rowid longlong PRIMARY KEY NOT NULL, Value char);
CREATE TABLE Statement (_rowid longlong PRIMARY KEY NOT NULL, clientID int, billingsFileID int, userFileID int, sentDate datetime, comment char, fromDate datetime, toDate datetime, totalBalance double, currentDue double, overdue30Days double, overdue60Days double, overdue90Days double, overdueOver90Days double, statementNumber char);
CREATE INDEX Statement_clientID_index ON Statement (clientID);
CREATE TABLE ClientCategory (_rowid longlong PRIMARY KEY NOT NULL, name char, collapsed int, orderNumber int);
CREATE TABLE RecurringInvoice (_rowid longlong PRIMARY KEY NOT NULL, clientID int, lastSentDate datetime, nextSendDate datetime, modifyDate datetime, recurMonths int, recurDay int, templatePath char, name char, lastPlannedSendDate datetime, includeUnbilled int);
CREATE INDEX RecurringInvoice_clientID_index ON RecurringInvoice (clientID);
CREATE TABLE ProFormaInvoice (billingsFileID int, comment char, createDate datetime, dueDate datetime, invoiceDate datetime, modifyDate datetime, _rowid longlong PRIMARY KEY NOT NULL, clientID int, userFileID int, name char, slipList char, templatePath char, total double, retainerAmountApplied double, customizationValues char, templatePreferenceID longlong);
CREATE INDEX ProFormaInvoice_clientID_index ON ProFormaInvoice (clientID);
CREATE TABLE ClientABLink (_rowid longlong PRIMARY KEY NOT NULL, clientID longlong, deviceUUID char, abUUID char, abAddressUUID char, abEmailUUID char);
CREATE INDEX ClientABLink_clientID_index ON ClientABLink (clientID);
CREATE INDEX ClientABLink_deviceUUID_index ON ClientABLink (deviceUUID);
CREATE INDEX ClientABLink_abUUID_index ON ClientABLink (abUUID);
CREATE TABLE ClientPhoto (_rowid longlong PRIMARY KEY NOT NULL, imageData object);
CREATE TABLE SlipConflict (_rowid longlong PRIMARY KEY NOT NULL, originalSlipID longlong, duplicateSlipID longlong);
CREATE TABLE DatabaseConfiguration (_rowid longlong PRIMARY KEY NOT NULL, schemaNumber int, databaseUUID char, databaseType int NOT NULL DEFAULT '0', primaryKeyOffset int NOT NULL, lastUsedReplicationOffset int NOT NULL DEFAULT '0');
CREATE TABLE InvoiceHtml (_rowid longlong PRIMARY KEY NOT NULL, html char, type int);
CREATE TABLE Currency (_rowid longlong PRIMARY KEY NOT NULL, name char, currencyCode char, currencySymbol char, exchangeRateToBase float DEFAULT '1', exchangeRateDate datetime, isBaseCurrency int DEFAULT '0', active int DEFAULT '1', localeIdentifier char, overrideLocaleIdentifier char, extra1 char, extra2 char, extra3 char, extra4 char);
CREATE TABLE EstimateHtml (_rowid longlong PRIMARY KEY NOT NULL, html char, type int);
CREATE TABLE Extra (_rowid longlong PRIMARY KEY NOT NULL, mimeType char, mimeSubtype char, internalType int, name char, dataValue object, stringValue char, datetimeValue datetime, doubleValue double, floatValue float, intValue int, parentEntity char, parentID longlong);
CREATE TABLE DatabaseReplicant (_rowid longlong PRIMARY KEY NOT NULL, date datetime, replicantPrimaryMACAddress char, replicationKey int NOT NULL DEFAULT '0', userID longlong, clientUUID char, lastChangeLogID longlong, lastImportedChangeSetUUID char, lastExportedChangeSetUUID char, lastSyncDate datetime, replicantType int NOT NULL DEFAULT '0', replicantName char, statusCode int NOT NULL DEFAULT '0', offlineCloneDate datetime);
CREATE TABLE OfflineConfiguration (_rowid longlong PRIMARY KEY NOT NULL, lastImportedChangeSetUUID char, lastExportedChangeSetUUID char, lastSyncDate datetime, masterName varchar, masterHostAddress varchar, masterAlternateHostAddress varchar, masterHostPort int, masterAlternateHostPort int, isActive int NOT NULL DEFAULT '0', statusCode int NOT NULL DEFAULT '0', fud datetime, offlineUUID varchar, cloudAccount varchar);
CREATE TABLE ReportTemplate (_rowid longlong PRIMARY KEY NOT NULL, templateData object, name char, behaviors char, createDate datetime, entityName char, modifyDate datetime, isActiveCode int, version int, thumbnailData object, thumbnailType char);
CREATE TABLE ProjectUser (_rowid longlong PRIMARY KEY NOT NULL, userID longlong NOT NULL, projectID longlong NOT NULL, createDate datetime, modifyDate datetime, hourlyRate double, mileageRate double);
CREATE TABLE FileStorage (_rowid longlong PRIMARY KEY NOT NULL, data object);
CREATE TABLE ReportTemplatePreference (_rowid longlong PRIMARY KEY NOT NULL, templateName char, reportTemplateID longlong, configuration object);
CREATE TABLE Identity (_rowid longlong PRIMARY KEY NOT NULL, logo object, logoType char, line1 char, line2 char, line3 char, line4 char, bankAccount char, bankIdentifier char, bankName char, bankAddress char, IBAN char, BIC char, extra1 char, extra2 char, extra3 char, extra4 char);
CREATE TABLE ConnectorMap (_rowid longlong PRIMARY KEY NOT NULL, foreignID char, foreignEntityType char, foreignDatabase char, foreignAppName char, parentID longlong, parentEntity char, createDate datetime, modifyDate datetime, lastPushDate datetime, lastPullDate datetime, userID longlong);
CREATE INDEX ConnectorMap_parentID_index ON ConnectorMap (parentID);
BEGIN;
CREATE TABLE change_table (_rowid INTEGER PRIMARY KEY, table_name char NOT NULL);
CREATE TABLE change_log (_rowid INTEGER PRIMARY KEY, _timestamp datetime, table_id longlong NOT NULL, primary_key longlong NOT NULL,operation char NOT NULL,changed_columns char, client_id char, user_id longlong, processed boolean DEFAULT FALSE);
CREATE INDEX change_log_table_id_index ON change_log (table_id);
CREATE INDEX change_log_primary_key_index ON change_log (primary_key);
CREATE TABLE master_change_log(_rowid INTEGER PRIMARY KEY,_timestamp datetime,table_id longlong NOT NULL,primary_key longlong NOT NULL,operation char NOT NULL,changed_columns char,client_id char,user_id longlong);
INSERT INTO change_table(_rowid, table_name) VALUES (1, 'BEXIgnore');
INSERT INTO change_table(_rowid, table_name) VALUES (2, 'Category');
INSERT INTO change_table(_rowid, table_name) VALUES (3, 'Client');
INSERT INTO change_table(_rowid, table_name) VALUES (4, 'ClientABLink');
INSERT INTO change_table(_rowid, table_name) VALUES (5, 'ClientCategory');
INSERT INTO change_table(_rowid, table_name) VALUES (6, 'ClientPhoto');
INSERT INTO change_table(_rowid, table_name) VALUES (46, 'ConnectorMap');
INSERT INTO change_table(_rowid, table_name) VALUES (7, 'ConsolidatedTax');
INSERT INTO change_table(_rowid, table_name) VALUES (35, 'Currency');
INSERT INTO change_table(_rowid, table_name) VALUES (8, 'Estimate');
INSERT INTO change_table(_rowid, table_name) VALUES (36, 'EstimateHtml');
INSERT INTO change_table(_rowid, table_name) VALUES (9, 'EstimateSlip');
INSERT INTO change_table(_rowid, table_name) VALUES (37, 'Extra');
INSERT INTO change_table(_rowid, table_name) VALUES (10, 'ExtraFieldNames');
INSERT INTO change_table(_rowid, table_name) VALUES (45, 'Identity');
INSERT INTO change_table(_rowid, table_name) VALUES (11, 'Invoice');
INSERT INTO change_table(_rowid, table_name) VALUES (34, 'InvoiceHtml');
INSERT INTO change_table(_rowid, table_name) VALUES (12, 'MCUserDefaultsStorage');
INSERT INTO change_table(_rowid, table_name) VALUES (13, 'Note');
INSERT INTO change_table(_rowid, table_name) VALUES (14, 'Payment');
INSERT INTO change_table(_rowid, table_name) VALUES (15, 'PaymentInvoiceEntry');
INSERT INTO change_table(_rowid, table_name) VALUES (16, 'PaymentMethodType');
INSERT INTO change_table(_rowid, table_name) VALUES (17, 'ProFormaInvoice');
INSERT INTO change_table(_rowid, table_name) VALUES (18, 'Project');
INSERT INTO change_table(_rowid, table_name) VALUES (19, 'ProjectStage');
INSERT INTO change_table(_rowid, table_name) VALUES (20, 'ProjectState');
INSERT INTO change_table(_rowid, table_name) VALUES (41, 'ProjectUser');
INSERT INTO change_table(_rowid, table_name) VALUES (21, 'RecurringInvoice');
INSERT INTO change_table(_rowid, table_name) VALUES (40, 'ReportTemplate');
INSERT INTO change_table(_rowid, table_name) VALUES (44, 'ReportTemplatePreference');
INSERT INTO change_table(_rowid, table_name) VALUES (22, 'Retainer');
INSERT INTO change_table(_rowid, table_name) VALUES (23, 'SlipConflict');
INSERT INTO change_table(_rowid, table_name) VALUES (24, 'SlipTemplate');
INSERT INTO change_table(_rowid, table_name) VALUES (25, 'Statement');
INSERT INTO change_table(_rowid, table_name) VALUES (26, 'Tax');
INSERT INTO change_table(_rowid, table_name) VALUES (27, 'TaxConsolidatedTaxEntry');
INSERT INTO change_table(_rowid, table_name) VALUES (28, 'TimeEntry');
INSERT INTO change_table(_rowid, table_name) VALUES (29, 'TimeSlip');
INSERT INTO change_table(_rowid, table_name) VALUES (30, 'TimeSlipType');
INSERT INTO change_table(_rowid, table_name) VALUES (31, 'URLReference');
INSERT INTO change_table(_rowid, table_name) VALUES (32, 'User');
COMMIT;
